/*
 * Decompiled with CFR 0.152.
 */
package com.smart.io;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.smart.io.PortManager;
import com.smart.io.WriterResult;
import java.io.IOException;
import java.util.Vector;

public class UsbPort
extends PortManager {
    private static final String TAG = UsbPort.class.getSimpleName();
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private UsbDevice usbDevice;
    private UsbManager usbManager;
    private Context mContext;
    private UsbDeviceConnection mmConnection;
    private UsbInterface mmIntf;
    private UsbEndpoint mmEndIn;
    private UsbEndpoint mmEndOut;

    public UsbPort(Context context, UsbDevice usbDevice) {
        this.mContext = context;
        this.usbDevice = usbDevice;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    private UsbPort() {
    }

    public void setUsbDevice(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    @Override
    public boolean openPort() {
        if (this.usbDevice != null) {
            if (!this.usbManager.hasPermission(this.usbDevice)) {
                Log.e((String)TAG, (String)"USB is not permission");
            } else if (this.checkUsbDevicePidVid(this.usbDevice)) {
                this.openUsbPort();
                if (this.mmEndOut != null && this.mmEndIn != null) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isConnect() {
        return false;
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    private void openUsbPort() {
        UsbInterface usbInterface;
        int count = this.usbDevice.getInterfaceCount();
        UsbInterface intf = null;
        int i = 0;
        if (i >= count || (intf = (usbInterface = this.usbDevice.getInterface(i))).getInterfaceClass() == 7) {
            // empty if block
        }
        if (intf != null) {
            this.mmIntf = intf;
            this.mmConnection = null;
            this.mmConnection = this.usbManager.openDevice(this.usbDevice);
            if (this.mmConnection != null && this.mmConnection.claimInterface(intf, true)) {
                for (i = 0; i < intf.getEndpointCount(); ++i) {
                    UsbEndpoint ep = intf.getEndpoint(i);
                    if (ep.getType() != 2) continue;
                    if (ep.getDirection() == 0) {
                        this.mmEndOut = ep;
                        continue;
                    }
                    this.mmEndIn = ep;
                }
            }
        }
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        if (data == null || data.size() <= 0) {
            throw new IllegalArgumentException("Data is empty or size is 0.");
        }
        int result = 0;
        Vector<Byte> sendData = new Vector<Byte>();
        for (int i = 0; i < data.size(); ++i) {
            if (sendData.size() >= 1024) {
                Log.e((String)TAG, (String)("i = " + i + "\tsendData size -> " + sendData.size() + "\tdata size -> " + data.size()));
                result += this.mmConnection.bulkTransfer(this.mmEndOut, this.convertVectorByteToBytes(sendData), sendData.size(), 1000);
                sendData.clear();
                Log.e((String)TAG, (String)("sendData.clear() size -> " + sendData.size()));
            }
            sendData.add(data.get(i));
        }
        if (sendData.size() > 0) {
            Log.e((String)TAG, (String)("sendData size -> " + sendData.size()));
            result += this.mmConnection.bulkTransfer(this.mmEndOut, this.convertVectorByteToBytes(sendData), sendData.size(), 1000);
        }
        if (result == data.size()) {
            Log.d((String)TAG, (String)"send success");
        }
    }

    @Override
    public void writeDataImadiately(Vector<Byte> data, int offset, int len, long timeout, WriterResult error) {
        if (data == null || data.size() <= 0) {
            error.error(-3);
        }
        int result = 0;
        Vector<Byte> sendData = new Vector<Byte>();
        for (int i = 0; i < data.size(); ++i) {
            if (sendData.size() >= 1024) {
                Log.e((String)TAG, (String)("i = " + i + "\tsendData size -> " + sendData.size() + "\tdata size -> " + data.size()));
                result += this.mmConnection.bulkTransfer(this.mmEndOut, this.convertVectorByteToBytes(sendData), sendData.size(), 1000);
                sendData.clear();
                Log.e((String)TAG, (String)("sendData.clear() size -> " + sendData.size()));
            }
            sendData.add(data.get(i));
        }
        if (sendData.size() > 0) {
            Log.e((String)TAG, (String)("sendData size -> " + sendData.size()));
            result += this.mmConnection.bulkTransfer(this.mmEndOut, this.convertVectorByteToBytes(sendData), sendData.size(), 1000);
        }
        if (result == data.size()) {
            Log.d((String)TAG, (String)"send success");
        } else {
            error.error(-1);
        }
    }

    @Override
    public void writeDataImadiately(byte[] data) throws IOException {
    }

    @Override
    public boolean readData(byte[] bytes, int len, long timeout) throws IOException {
        if (this.mmConnection != null) {
            int result = this.mmConnection.bulkTransfer(this.mmEndIn, bytes, len, (int)timeout);
            return result == len;
        }
        return false;
    }

    @Override
    public boolean closePort() {
        if (this.mmIntf != null && this.mmConnection != null) {
            this.mmConnection.releaseInterface(this.mmIntf);
            this.mmConnection.close();
            this.mmConnection = null;
            return true;
        }
        return false;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    private boolean checkUsbDevicePidVid(UsbDevice dev) {
        return true;
    }
}

